-- DataRowState : Automatische Filter / Register für F2-Fenster : https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/F2
 
 --
 CREATE OR REPLACE FUNCTION getRowState(IN src_dataRow art) RETURNS varchar AS $$
     DECLARE stats varchar;
     BEGIN
       stats:= 'sFertArt';
       
       IF src_dataRow.ak_neuanlage THEN
           stats:= 'sNeu';
       END IF;
       IF src_dataRow.ak_auslauf IS NOT NULL OR src_dataRow.ak_auslauf_aufbrauch THEN
           stats:= stats || ',' || 'sAuslauf';
       END IF;
       IF src_dataRow.ak_fertigung THEN
           stats:= stats || ',' || 'sFertArt';
       END IF;
       IF ic_for_ac(src_dataRow.ak_ac)=3 THEN
           stats:= stats || ',' || 'sRohmat';
       END IF;
       IF EXISTS(SELECT true FROM stv WHERE st_zn = src_dataRow.ak_nr) THEN
           stats:= stats || ',' || 'sStkl';
       END IF;
       IF EXISTS(SELECT true FROM stv WHERE st_n = src_dataRow.ak_nr) THEN
           stats:= stats || ',' || 'sElemStkl';
       END IF;
       
       RETURN TRIM(stats, ',');
     END $$ LANGUAGE plpgsql STABLE STRICT;
 --
 
 --
 CREATE OR REPLACE FUNCTION getRowState(IN src_table varchar, IN src_dbrid varchar) RETURNS varchar AS $$
     DECLARE stats varchar;
             rec record; -- aktueller Datensatz
     BEGIN
       stats:= '';
       -- Auftrag
       IF src_table = 'auftg' THEN
           SELECT ag_done, ag_storno, coalesce(ag_aldatum, ag_ldatum) AS termin, ag_dokunr IS NULL AS nodok INTO rec FROM auftg WHERE auftg.dbrid = src_dbrid;
           IF NOT rec.ag_done AND NOT rec.ag_storno THEN
               stats:= 'sOffen';
               IF rec.nodok THEN
                   stats:= stats || ',' || 'sOhneDok';
               END IF;
               IF rec.termin < current_date THEN
                   stats:= stats || ',' || 'sVerzug';
               END IF;
           ELSE
               IF rec.ag_done THEN
                   stats:= 'sDone';
               END IF;
               IF rec.ag_storno THEN
                   stats:= stats || ',' || 'sStorno';
               END IF;
           END IF;
       -- ABK
       ELSIF src_table = 'abk' THEN
           SELECT ab_done, ab_storno, ab_print, ab_inplantaf, ab_buch, ab_at IS NULL AS noterm INTO rec FROM abk WHERE abk.dbrid = src_dbrid;
           IF NOT rec.ab_done AND NOT rec.ab_storno THEN
               stats:= 'sOffen';
               IF rec.noterm THEN
                   stats:= stats || ',' || 'sOhneTerm';
               END IF;
               IF rec.ab_inplantaf THEN
                   stats:= stats || ',' || 'sInPlantaf';
               END IF;
               IF rec.ab_print THEN
                   stats:= stats || ',' || 'sPrint';
               END IF;
           ELSE
               IF rec.ab_done THEN
                   stats:= 'sDone';
               END IF;
               IF rec.ab_storno THEN
                   stats:= stats || ',' || 'sStorno';
               END IF;
               IF rec.ab_buch THEN
                   stats:= stats || ',' || 'sVerbucht';
               END IF;
           END IF;
       -- Lieferschein
       ELSIF src_table = 'lieferschein' THEN -- vgl. VIEW lieferschein
           SELECT beld_definitiv, beld_print, beld_verbucht INTO rec FROM lieferschein WHERE lieferschein.dbrid = src_dbrid;
           IF rec.beld_definitiv THEN
               stats:= 'sDefinitiv';
           END IF;
           IF rec.beld_print THEN
               stats:= stats || ',' || 'sPrint';
           END IF;
           IF rec.beld_verbucht THEN
               stats:= stats || ',' || 'sVerbucht';
           END IF;
       -- Ausgangsrechnung
       ELSIF src_table = 'belkopf' THEN
           SELECT be_def, be_freigabe, be_zahl_erledigt,
               EXISTS(SELECT true FROM picndoku WHERE pd_tablename = 'belkopf' AND pd_doktype = 'rechnung' AND pd_dbrid = belkopf.dbrid AND pd_dokident = belkopf.be_bnr) AS printed
           INTO rec FROM belkopf WHERE belkopf.dbrid = src_dbrid;
           IF rec.be_def THEN
               stats:= 'sDefinitiv';
           END IF;
           IF rec.be_freigabe THEN
               stats:= stats || ',' || 'sFreigabe';
           END IF;
           IF rec.printed THEN
               stats:= stats || ',' || 'sPrint';
           END IF;
           IF NOT rec.be_zahl_erledigt THEN
               stats:= stats || ',' || 'sZahlOffen';
           END IF;
       -- Einkauf
       ELSIF src_table = 'ldsdok' THEN
           SELECT ld_done, ld_storno, ld_dokunr IS NULL AS nodok, ld_abnr IS NULL noab, coalesce(ld_termv, ld_terml, ld_term) AS termin, ld_rech_eing
           INTO rec FROM ldsdok WHERE ldsdok.dbrid = src_dbrid;
           IF NOT rec.ld_done AND NOT rec.ld_storno THEN
               stats:= 'sOffen';
               IF rec.nodok THEN
                   stats = stats || ',' || 'sOhneDok';
               END IF;
               IF rec.noab THEN
                   stats = stats || ',' || 'sOhneAB';
               END IF;
               IF rec.termin < current_date THEN
                   stats = stats || ',' || 'sVerzug';
               END IF;
           ELSE
               IF rec.ld_done THEN
                   stats:= 'sDone';
               END IF;
               IF rec.ld_storno THEN
                   stats:= stats || ',' || 'sStorno';
               END IF;
               IF NOT rec.ld_rech_eing THEN
                   stats:= stats || ',' || 'sZahlOffen';
               END IF;
           END IF;
       -- Eingangsrechnung
       ELSIF src_table = 'eingrech' THEN -- vgl. VIEW eingrech
           SELECT beld_geprueft, beld_freigabe, beld_definitiv, beld_verbucht INTO rec FROM eingrech WHERE eingrech.dbrid = src_dbrid;
           IF NOT rec.beld_verbucht THEN
               stats:= 'sOffen';
               IF rec.beld_geprueft THEN
                   stats:= 'sGeprueft';
               END IF;
               IF rec.beld_freigabe THEN
                   stats:= stats || ',' || 'sFreigabe';
               END IF;
               IF rec.beld_definitiv THEN
                   stats:= stats || ',' || 'sDefinitiv';
               END IF;
           ELSE
               IF rec.beld_verbucht THEN -- wegen NULL
                   stats:= 'sVerbucht';
               END IF;
           END IF;
       -- Mitarbeiter
       ELSIF src_table = 'llv' THEN
           SELECT ll_db_login, ll_einstd, ll_endd INTO rec FROM llv WHERE llv.dbrid = src_dbrid;
           IF coalesce(rec.ll_endd, current_date+1) > current_date THEN
               IF rec.ll_einstd <= current_date THEN
                   stats:= 'sEingest';
               END IF;
           ELSE
               stats:= 'sAusgesch';
           END IF;
           IF rec.ll_db_login THEN
               stats:= stats || ',' || 'sLogin';
           END IF;
       -- Artikel
       ELSIF src_table = 'art' THEN
           SELECT getRowState(art) INTO stats FROM art WHERE art.dbrid = src_dbrid;
       END IF;
       
       RETURN TRIM(stats, ',');
    
     END $$ LANGUAGE plpgsql STABLE STRICT;
   --
---

-- KeyWordSearch >>> https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/KeywordSearch
 
 -- Trennt einen String anhand eines fest definierten Regex-Patterns
 -- Längster Begriff zuerst. Originaler String kann mit ausgegeben werden (vgl. Erstellen von Schlüsselbegriffen).
 -- Ergebnis mit 1 Zeichen werden ausgegeben, wenn Begriffe vorher mehr als 1 Zeichen. z.B. "AB C" => "AB", "C", aber "A B C" => "A B C" (nicht "A", "B", "C")
 CREATE OR REPLACE FUNCTION TSystem.kws_generate_split_keywords(IN inString varchar, IN return_orig boolean DEFAULT FALSE, OUT keyword varchar) RETURNS SETOF varchar AS $$
     DECLARE splitPattern varchar;
          trimPattern varchar;
          rec_words record;
          rec_digits record;
          first_keyword boolean;
     BEGIN
       inString:=AEOEUE_UPPER(inString);
       splitPattern:=
                    E'(' || -- Fall 1 (Leerzeichen und allg. Sonderzeichen, kein %)
                        E'[\\s!"#$&()*+\\/:;<=>?@\\[\\]\\\\^_`{|}~Øø'']+' || -- Bei Leerzeichen (\s) und diesen Sonderzeichen trennen (beachte Escape \\ wird zu \), wenn
                    E')' || -- Ende Fall 1
                    E'|(' || -- oder Fall 2 (Dezimal- und Nummerkreis-Zeichen)
                        E'[,.]+' || -- diese trennen, wenn
                        E'(?=' || -- danach
                            E'[0-9]*[[:alpha:]äüöÄÜÖß]+' || -- nicht nur Zahlen folgen (beliebig vielen Zahlen folgt ein Alphabetzeichen)
                        E')' ||
                    E')' || -- Ende Fall 2
                    E'|(' || -- oder Fall 3 (Artikelindex mit Minus)
                        E'-+' || -- Minus trennen, wenn
                        E'(?!' || -- danach nicht direkt
                            E'''' || -- Hochkomma
                        E')' ||
                    E')' -- Ende Fall 3
       ;
       trimPattern:= E'!"#$&()*+/:;<=>?@[]\^_`{|}~Øø,. '; -- alle Leer- und Sonderzeichen am Anfang und Ende entfernen, außer ' und - (% nur am Anfang unterbinden, s.u.)
       first_keyword:=true;
       
       FOR rec_words IN SELECT DISTINCT word, length(word) AS word_length FROM (SELECT ltrim(btrim(regexp_split_to_table, trimPattern), '%') AS word FROM regexp_split_to_table(trim(inString), splitPattern)) AS sub ORDER BY length(word) DESC LOOP -- die längsten Begriffe zuerst
        IF rec_words.word_length > 0 THEN
            IF rec_words.word_length = 1 AND first_keyword THEN -- Es gibt nur Worte der Länge 1 (ORDER BY length), dann nur Original ausgeben. Bei "AB C" => "AB" und "C" ausgeben.
                return_orig:=true;
                rec_words.word:=NULL;
                EXIT;
            END IF;
            first_keyword:=false;
            keyword:=rec_words.word;
            RETURN NEXT;
            -- Bei Punkt und Komma die Werte dahinter nochmal einzeln ausweisen. 1.123.456 => "123" und "456"
            FOR rec_digits IN SELECT DISTINCT word, length(word) AS word_length FROM (SELECT regexp_split_to_table AS word FROM regexp_split_to_table(substring(rec_words.word, '[.,].*'), E'[,.]+')) AS sub WHERE word <> rec_words.word ORDER by length(word) DESC LOOP
                IF rec_digits.word_length > 0 THEN
                    keyword:=rec_digits.word;
                    RETURN NEXT;
                END IF;
            END LOOP;
        END IF;
       END LOOP;
       
       -- auch das Original mit ausgeben
       IF return_orig AND rec_words.word IS DISTINCT FROM inString THEN
           keyword:=inString;
           RETURN NEXT;
       END IF;
     END $$ LANGUAGE plpgsql STABLE STRICT;
 --
 
 -- vollständiger Suchstring 'ABC  15.5' => 'ABC%15.5%'. Verwendung in Standardsuche als Fallback
 CREATE OR REPLACE FUNCTION TSystem.kws_generate_split_keywords_full_string(inString varchar) RETURNS varchar AS $$
     BEGIN
       RETURN regexp_replace(trim(inString), E'\\s+', '%') || '%';
     END $$ LANGUAGE plpgsql IMMUTABLE STRICT;
 --
 
 -- Liefert dbrids einer bestimmten Tabelle anhand (aufgesplitteten) Suchtext. Evtl. eingeschränkt auf best. Suchfelder. (NULL oder '' = alle) 
 -- Suche ist konjunktional: nur Ergebnisse, bei denen alle Suchbegriffe treffen.
 -- Oder vollständig exakt/strikt: nur Ergebnisse, bei denen der vollständige Suchbegriff trifft. (% für LIKE wird nicht angefügt, kann aber im Suchbegriff angg. werden)  
 CREATE OR REPLACE FUNCTION TSystem.kws_get_recnodbrids_by_keyword_and(IN inSearchString varchar, IN inSearchFields varchar, IN trg_table varchar, IN strictSearch boolean DEFAULT FALSE, OUT dbrid varchar, OUT hitfields varchar) RETURNS SETOF record AS $$
     DECLARE search_query varchar;
             search_units varchar;
             search_where varchar;
             keyword_value varchar;
             first_keyword boolean;
     BEGIN
       -- Wenn Suchbegriff(e) vorhanden sind, dann dynamisches Statement (search_query) zusammenstellen.
       IF (SELECT count(keyword) FROM TSystem.kws_generate_split_keywords(inSearchString)) > 0 THEN
           first_keyword:= true; search_units:= ''; search_where:= '';
           
           -- WHERE-Bedingungen anhand der Suchbegriffe für konjuktionale Abfrage (search_where) und Subselect r_unit (search_units) zusammenstellen.
           -- Verwendung weiter unten. Fürs Verständis erst search_query unten anschauen. Ausgeführtes Query wird als root ausgegeben.
           FOR keyword_value IN SELECT AEOEUE_UPPER(keyword) || IFTHEN(strictSearch OR length(keyword) < 3, '', '%') FROM TSystem.kws_generate_split_keywords(inSearchString) LOOP
               -- Subquery beim ersten Suchbegriff (s.u.) schließen
               IF first_keyword THEN
                   search_where:= search_where || '
                           AND AEOEUE_UPPER(r_value) LIKE ' || quote_literal(keyword_value) || '
                         ) AS sub
                       WHERE true';
                   first_keyword:=false;
               ELSE
                   -- weitere Suchbegriffe im äußeren SELECT einschränken.
                   search_where:= search_where || '  
                         AND r_dbrid IN (SELECT r_dbrid FROM recnokeyword
                                         WHERE r_tablename = ' || quote_literal(trg_table) || '
                                           AND r_descr = ''keywordsearch''
                                           AND AEOEUE_UPPER(r_value) LIKE ' || quote_literal(keyword_value) || '
                                           AND ( nullif(' || quote_nullable(inSearchFields) || ', '''') IS NULL
                                                 OR recnokeyword.r_unit IN (SELECT regexp_split_to_table(' || quote_nullable(inSearchFields) || ', '';''))
                                               )
                                        )';
                   
                   search_units:= search_units || '
                                 OR ';
               END IF;
               search_units:= search_units || 'AEOEUE_UPPER(r_value) LIKE ' || quote_literal(keyword_value);
           END LOOP;
           
           -- Beim ersten Suchbegriff die Daten im Subquery einschränken, damit WHERE für weitere Suchbegriffe weniger zu tun hat.
           -- QueryPlaner optimiert anhand des inneren SELECTs und schränkt äußeres SELECT implizit ein.
           search_query:= '
                       SELECT r_dbrid, array_to_string(ARRAY(
                         SELECT DISTINCT r_unit
                         FROM recnokeyword
                         WHERE r_tablename = ' || quote_literal(trg_table) || '
                           AND r_descr = ''keywordsearch''
                           AND ( nullif(' || quote_nullable(inSearchFields) || ', '''') IS NULL -- Keine Angabe von Suchfeldern
                                 OR r_unit IN (SELECT regexp_split_to_table(' || quote_nullable(inSearchFields) || ', '';'')) -- Einschränkung auf Suchfelder
                               )
                           AND r_dbrid = sub.r_dbrid
                           AND ( ' || search_units || '
                               )
                         ), '';'')::varchar
                       FROM (
                         SELECT DISTINCT r_dbrid
                         FROM recnokeyword
                         WHERE r_tablename = ' || quote_literal(trg_table) || '
                           AND r_descr = ''keywordsearch''
                           AND ( nullif(' || quote_nullable(inSearchFields) || ', '''') IS NULL -- Keine Angabe von Suchfeldern
                                 OR r_unit IN (SELECT regexp_split_to_table(' || quote_nullable(inSearchFields) || ', '';'')) -- Einschränkung auf Suchfelder
                               )' || search_where;
       ELSE -- Wenn KEIN Suchbegriff vorhanden, dann die aktuellste 500 Datensätze zurückgeben.
           search_query:= '
           SELECT dbrid, NULL::varchar AS hitfields
           FROM ' || quote_ident(trg_table) || '
           ORDER BY coalesce(modified_date, insert_date) DESC NULLS LAST
           LIMIT 500';
       END IF;
       
       IF current_user='root' THEN
           RAISE NOTICE '%', search_query;
       END IF;
       
       RETURN QUERY EXECUTE search_query;
     END $$ LANGUAGE plpgsql STABLE;
 --
 
 --
 CREATE OR REPLACE FUNCTION TSystem.kws_get_recnodbrids_by_keyword_mask(IN inSearchString varchar, IN inSearchFields varchar, IN trg_table varchar, IN strictSearch boolean DEFAULT FALSE, OUT dbrid varchar, OUT bitmask INTEGER, OUT hitfields varchar) RETURNS SETOF record AS $$
     DECLARE keyword_value varchar;
             r record;
             I INTEGER;
             search_query varchar;
             search_query_mask varchar;
             search_where varchar;
     BEGIN
       -- Wenn Suchbegriff(e) vorhanden sind, dann dynamisches Statement (search_query) zusammenstellen.
       IF (SELECT count(keyword) FROM TSystem.kws_generate_split_keywords(inSearchString)) > 0 THEN
           I:=0; search_query_mask:=''; search_where:='';
           FOR keyword_value IN SELECT AEOEUE_UPPER(keyword) || IFTHEN(strictSearch OR length(keyword) < 3, '', '%') FROM TSystem.kws_generate_split_keywords(inSearchString) LOOP
               search_query_mask:= search_query_mask || IFTHEN(I>0, '|', '') || '((AEOEUE_UPPER(r_value) LIKE AEOEUE_UPPER(' || quote_literal(keyword_value) || ')) :: INTEGER << ' || I || ')';
               search_where:= search_where || IFTHEN(I>0, ' OR ', '') || 'AEOEUE_UPPER(r_value) LIKE AEOEUE_UPPER(' || quote_literal(keyword_value) || ')';
               I:=I+1;
           END LOOP;
           search_query:='
               SELECT r_dbrid, r_unit, ' || search_query_mask || ' AS bitmask
               FROM recnokeyword
               WHERE r_tablename = ' || quote_literal(trg_table) || '
                 AND r_descr = ''keywordsearch''
                 AND ( nullif(' || quote_nullable(inSearchFields) || ', '''') IS NULL -- Keine Angabe von Suchfeldern
                       OR
                       r_unit IN (SELECT regexp_split_to_table(' || quote_nullable(inSearchFields) || ', '';'')) -- Einschränkung auf Suchfelder
                     )
                 AND (' || search_where || ')
               ORDER BY r_dbrid';
           
           IF current_user IN ('root', 'docker', 'postgres') THEN
               RAISE NOTICE '%', search_query;
           END IF;
           
           FOR r IN EXECUTE search_query LOOP
               IF r.r_dbrid IS DISTINCT FROM dbrid THEN --neuer Treffersatz beginnt
                   --letzten Datensatz so rauswerfen
                   IF dbrid IS NOT NULL THEN --ersten leeren Satz ausschliessen
                       RETURN NEXT;
                   END IF;
                   dbrid:=r.r_dbrid;
                   bitmask:=0;
                   hitfields:='';
               END IF;
               bitmask := bitmask | r.bitmask;
               IF hitfields <> '' THEN
                   hitfields := hitfields || ';';
               END IF;  
               hitfields := hitfields || r.r_unit; 
           END LOOP;
       END IF;
       
       IF dbrid IS NOT NULL THEN
           RETURN NEXT;
       END IF;
     END $$ LANGUAGE plpgsql STABLE;
 --
 
 -- Schlüsselworte für normale Tabellenstruktur.
 -- Eingabeparameter (rkategorie, rtablename, rdbrid, rvalue, pname, runit)
 -- Intern anhand von Kategorie unterscheiden und entsprechende Inserts / Updates machen
 
 /*CREATE OR REPLACE FUNCTION TSystem.kws_CreateKeyword(rkategorie varchar, rtablename varchar, rdbrid varchar, rvalue varchar, pname varchar, runit varchar) RETURNS VOID AS $$
   BEGIN
     IF (SELECT nullif(TRIM(value), '') IS NOT NULL) THEN
         INSERT INTO recnokeyword(r_kategorie, r_tablename, r_dbrid, r_value, r_reg_pname, r_unit, r_descr)
         SELECT rkategorie, rtablename, rdbrid, AEOEUE_UPPER(keyword), pname, runit, coalesce(reg_bez, lang_text(10278))
         FROM TSystem.kws_generate_split_keywords(rvalue, true) -- true: auch komplettes Schlüsselwort (value) eintragen 
         --das Folgende wird im Trigger selbst abgefangen, wodurch mit DisableTrigger eine höhere Geschwindigkeit erreicht werden kann
         --WHERE NOT EXISTS(SELECT true FROM recnokeyword WHERE r_tablename=tablename AND r_kategorie='internal system usage' AND r_descr=descr
         --                                                 AND r_value=AEOEUE_UPPER(generate_split_keywords) AND r_unit=unit AND r_dbrid=ddbrid);
           LEFT JOIN RecNoGroup ON reg_pname=pname;
     END IF;
     RETURN;
   END $$ LANGUAGE plpgsql;*/
 --
 
 --
 CREATE OR REPLACE FUNCTION tsystem.kws_createkeyword(tablename varchar, value varchar, unit varchar, ddbrid varchar, descr varchar DEFAULT 'keywordsearch'::varchar) RETURNS VOID AS $$
     BEGIN
       IF (SELECT nullif(TRIM(value), '') IS NOT NULL) THEN
           INSERT INTO recnokeyword(r_tablename, r_value, r_unit, r_dbrid, r_kategorie, r_descr)
           SELECT tablename, AEOEUE_UPPER(keyword), unit, ddbrid, 'internal system usage', descr
           FROM TSystem.kws_generate_split_keywords(value, true); -- true: auch komplettes Schlüsselwort (value) eintragen 
           --das Folgende wird im Trigger selbst abgefangen, wodurch mit DisableTrigger eine höhere Geschwindigkeit erreicht werden kann
           --WHERE NOT EXISTS(SELECT true FROM recnokeyword WHERE r_tablename=tablename AND r_kategorie='internal system usage' AND r_descr=descr
           --                                                 AND r_value=AEOEUE_UPPER(generate_split_keywords) AND r_unit=unit AND r_dbrid=ddbrid);
       END IF;
       RETURN;
     END $$ LANGUAGE plpgsql;
 --
 
 --
 CREATE OR REPLACE FUNCTION TSystem.kws_CreateKeyword(tablename varchar, value INTEGER, unit varchar, ddbrid varchar) RETURNS VOID AS $$
     BEGIN
       PERFORM TSystem.kws_CreateKeyword(tablename, value::varchar, unit, ddbrid);
       RETURN;
     END $$ LANGUAGE plpgsql;
 --
 
 --
 CREATE OR REPLACE FUNCTION TSystem.kws_create_keywords(IN src_dataRow adk) RETURNS VOID AS $$
     DECLARE keytable varchar;
          keydbrid varchar;
          r record;
     BEGIN
         keytable:='adk';
         keydbrid:=src_dataRow.dbrid;
         DELETE FROM recnokeyword WHERE r_tablename=keytable AND r_dbrid=keydbrid AND r_descr='keywordsearch' AND r_kategorie='internal system usage';
         --
         SELECT src_dataRow.*, a1_knr, a2_knr INTO r FROM (SELECT src_dataRow.*) adk LEFT JOIN adk1 ON a1_krz=ad_krz LEFT JOIN adk2 ON a2_krz=ad_krz;
         
         PERFORM TSystem.kws_CreateKeyword(keytable, r.ad_krz, 'ad_krz', keydbrid);
         PERFORM TSystem.kws_CreateKeyword(keytable, r.ad_fa1, 'ad_fa1', keydbrid);
         PERFORM TSystem.kws_CreateKeyword(keytable, r.ad_fa2, 'ad_fa2', keydbrid);
         PERFORM TSystem.kws_CreateKeyword(keytable, r.ad_name, 'ad_name', keydbrid);
         PERFORM TSystem.kws_CreateKeyword(keytable, r.ad_vorn, 'ad_vorn', keydbrid);
         PERFORM TSystem.kws_CreateKeyword(keytable, r.ad_str, 'ad_str', keydbrid);
         PERFORM TSystem.kws_CreateKeyword(keytable, r.ad_plz, 'ad_plz', keydbrid);
         PERFORM TSystem.kws_CreateKeyword(keytable, r.ad_ort, 'ad_ort', keydbrid);
         PERFORM TSystem.kws_CreateKeyword(keytable, r.ad_tel1, 'ad_tel1', keydbrid);
         PERFORM TSystem.kws_CreateKeyword(keytable, r.ad_tel2, 'ad_tel2', keydbrid);
         PERFORM TSystem.kws_CreateKeyword(keytable, r.ad_fax, 'ad_fax', keydbrid);
         PERFORM TSystem.kws_CreateKeyword(keytable, r.ad_faxpriv, 'ad_faxpriv', keydbrid);
         PERFORM TSystem.kws_CreateKeyword(keytable, r.ad_mobil, 'ad_mobil', keydbrid);
         PERFORM TSystem.kws_CreateKeyword(keytable, r.ad_email1, 'ad_email1', keydbrid);
         PERFORM TSystem.kws_CreateKeyword(keytable, r.ad_email2, 'ad_email2', keydbrid);
         PERFORM TSystem.kws_CreateKeyword(keytable, r.ad_such, 'ad_such', keydbrid);
         PERFORM TSystem.kws_CreateKeyword(keytable, r.a1_knr, 'a1_knr', keydbrid);
         PERFORM TSystem.kws_CreateKeyword(keytable, r.a2_knr, 'a2_knr', keydbrid);
         --PERFORM TSystem.kws_CreateKeyword('adk', ap_name, r.dbrid) FROM adkap WHERE ap_ad_krz=adkrz;
         FOR r IN SELECT ap_name, ap_vorn, ap_tel, ap_mobil, ap_mail, keydbrid FROM adkap WHERE ap_ad_krz=r.ad_krz LOOP
        PERFORM TSystem.kws_CreateKeyword(keytable, r.ap_name, 'ap_name', keydbrid);
        PERFORM TSystem.kws_CreateKeyword(keytable, r.ap_vorn, 'ap_vorn', keydbrid);
        PERFORM TSystem.kws_CreateKeyword(keytable, r.ap_tel, 'ap_tel', keydbrid);
        PERFORM TSystem.kws_CreateKeyword(keytable, r.ap_mobil, 'ap_mobil', keydbrid);
        PERFORM TSystem.kws_CreateKeyword(keytable, r.ap_mail, 'ap_mail', keydbrid);
         END LOOP;
         RETURN;
     END $$ LANGUAGE plpgsql;
 --
 
 -- Artikelstamm, Lieferantenpreisen und Kundenartikeln
 CREATE OR REPLACE FUNCTION TSystem.kws_create_keywords(IN src_dataRow art) RETURNS VOID AS $$
     DECLARE r  record;
             r2 record;
             r3 record;
             keytable varchar;
             keydbrid varchar;
     BEGIN
       keytable:='art';
       keydbrid:=src_dataRow.dbrid;
       DELETE FROM recnokeyword WHERE r_tablename=keytable AND r_dbrid=keydbrid AND r_descr='keywordsearch' AND r_kategorie='internal system usage';
       
       --ACHTUNG, bei Hinzufügen von Spalten ART-Trigger (OF) anpassen!
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ak_ac, 'ak_ac', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ak_nr, 'ak_nr', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ak_bez, 'ak_bez', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ak_znr, 'ak_znr', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ak_mat, 'ak_mat', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ak_din, 'ak_din', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ak_dim, 'ak_dim', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ak_such, 'ak_such', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ak_ordk, 'ak_ordk', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ak_allg1, 'ak_allg1', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ak_hersteller, 'ak_hersteller', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ak_herstelleraknr, 'ak_herstelleraknr', keydbrid);
       
       -- Lieferanten und Lieferantenartikelbezeichnung aller gültigen EPreis-Datensätze
       FOR r IN SELECT DISTINCT e_lkn, e_best FROM epreis WHERE e_aknr = src_dataRow.ak_nr
                                                            AND ( coalesce(e_gdatum,  current_date) <= current_date)
                                                            AND ( coalesce(e_bisdatum,current_date) >= current_date)
                                                            AND e_lkn <> '#'
                                                            AND e_aknr <> 'AW.EXTERN'
       LOOP
           PERFORM TSystem.kws_CreateKeyword(keytable, r.e_lkn , 'e_lkn', keydbrid);
           PERFORM TSystem.kws_CreateKeyword(keytable, r.e_best, 'e_best', keydbrid);
       END LOOP;
       
       -- Kunde und Kundenartikelbezeichnung
       FOR r2 IN SELECT DISTINCT az_prokrz, az_kunr, az_kunr_referenz FROM artzuo WHERE az_pronr = src_dataRow.ak_nr
                                                                   AND ( coalesce(az_gdatum,  current_date) <= current_date)
                                                                   AND ( coalesce(az_bisdatum,current_date) >= current_date)
       LOOP
           PERFORM TSystem.kws_CreateKeyword(keytable, r2.az_prokrz       , 'az_prokrz'       , keydbrid);
           PERFORM TSystem.kws_CreateKeyword(keytable, r2.az_kunr         , 'az_kunr'         , keydbrid);
           PERFORM TSystem.kws_CreateKeyword(keytable, r2.az_kunr_referenz, 'az_kunr_referenz', keydbrid);
       END LOOP;
       
       -- ASK-Index
       FOR r3 IN SELECT DISTINCT op_ix FROM opl WHERE op_n = src_dataRow.ak_nr
       LOOP
           PERFORM TSystem.kws_CreateKeyword(keytable, r3.op_ix, 'op_ix', keydbrid);
       END LOOP;
       
       RETURN;
     END $$ LANGUAGE plpgsql;
 --
 
 -- Auftrag
 CREATE OR REPLACE FUNCTION TSystem.kws_create_keywords(IN src_dataRow auftg) RETURNS VOID AS $$
     DECLARE r record;
          keytable varchar;
          keydbrid varchar;
     BEGIN
       keytable:='auftg';
       keydbrid:=src_dataRow.dbrid;
       DELETE FROM recnokeyword WHERE r_tablename=keytable AND r_dbrid=keydbrid AND r_descr='keywordsearch' AND r_kategorie='internal system usage';
       --

       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ag_nr,  'ag_nr', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ag_akbz,  'ag_akbz', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ag_an_nr, 'ag_an_nr', keydbrid);--an_nr?
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ag_aknr_referenz, 'ag_aknr_referenz', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ag_bda, 'ag_bda', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ag_dokunr, 'ag_dokunr', keydbrid);

       IF src_dataRow.ag_astat <> 'I' THEN
          -- ag_post Positionszusatzfelder, durch Usereingabe
          PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ag_post1::varchar(100), 'ag_post1', keydbrid);
          PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ag_post2::varchar(100), 'ag_post2', keydbrid);
          PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ag_post3::varchar(100), 'ag_post3', keydbrid);
          /*PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ag_post4, 'ag_post4', keydbrid);
          PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ag_post5, 'ag_post5', keydbrid);
          PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ag_post6, 'ag_post6', keydbrid);
          PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ag_post7, 'ag_post7', keydbrid); */
       END IF;

       --
       IF src_dataRow.ag_astat = 'I' THEN
           PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ag_parentabk, 'ab_ix', keydbrid);
           PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ag_ownabk, 'ab_ix', keydbrid);
       ELSE
           PERFORM TSystem.kws_CreateKeyword(keytable, tplanterm.auftg_get_abk(src_dataRow.ag_id), 'ab_ix', keydbrid);
       END IF;
       --PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ag_lkn, 'ag_lkn', keydbrid);

       RETURN;
     END $$ LANGUAGE plpgsql;
 --
    
 -- Einkauf
 CREATE OR REPLACE FUNCTION TSystem.kws_create_keywords(IN src_dataRow ldsdok) RETURNS VOID AS $$
     DECLARE r record;
             keytable varchar;
             keydbrid varchar;
     BEGIN
       keytable:='ldsdok';
       keydbrid:=src_dataRow.dbrid;
       DELETE FROM recnokeyword WHERE r_tablename=keytable AND r_dbrid=keydbrid AND r_descr='keywordsearch' AND r_kategorie='internal system usage';
       --
       
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ld_auftg,  'ld_auftg', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ld_an_nr, 'ld_an_nr', keydbrid);--an_nr?
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ld_akbz, 'ld_akbz', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ld_bem, 'ld_bem', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ld_ekref, 'ld_ekref', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ld_abk, 'ab_ix', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ld_dokunr, 'ld_dokunr', keydbrid);
       -- PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ld_kn, 'ld_kn', keydbrid);
       RETURN;
     END $$ LANGUAGE plpgsql;
 --

 -- ABK
 CREATE OR REPLACE FUNCTION TSystem.kws_create_keywords(IN src_dataRow abk) RETURNS VOID AS $$
     DECLARE r record;
             r2 record;
             keytable varchar;
             keydbrid varchar;
     BEGIN
       keytable:='abk';
       keydbrid:=src_dataRow.dbrid;
       DELETE FROM recnokeyword WHERE r_tablename=keytable AND r_dbrid=keydbrid AND r_descr='keywordsearch' AND r_kategorie='internal system usage';
       --
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ab_ix,       'ab_ix', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ab_ap_nr,    'ab_ap_nr', keydbrid);
       --PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ab_ap_bem,   'ab_ap_bem', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ab_an_nr,    'ab_an_nr', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.ab_keyvalue, 'ab_keyvalue', keydbrid);
       --
       RETURN;
     END $$ LANGUAGE plpgsql; 
 
 -- Projekt
 CREATE OR REPLACE FUNCTION TSystem.kws_create_keywords(IN src_dataRow anl) RETURNS VOID AS $$
     DECLARE r record;
             r2 record;
             keytable varchar;
             keydbrid varchar;
     BEGIN
       keytable:='anl';
       keydbrid:=src_dataRow.dbrid;
       DELETE FROM recnokeyword WHERE r_tablename=keytable AND r_dbrid=keydbrid AND r_descr='keywordsearch' AND r_kategorie='internal system usage';
       --
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.an_nr,  'an_nr', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.an_bez,  'an_bez', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.an_such,  'an_such', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.an_ag_nr,  'an_ag_nr', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.an_ab_ix,  'an_ab_ix', keydbrid);
       
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.an_best,  'an_best', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.an_hest,  'an_hest', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.an_lief,  'an_lief', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.an_inst,  'an_inst', keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.an_sortkrz,  'an_sortkrz', keydbrid);
       --
       RETURN;
     END $$ LANGUAGE plpgsql;
 --

 -- Ausgangsrechnung
 CREATE OR REPLACE FUNCTION TSystem.kws_create_keywords(IN src_dataRow belkopf) RETURNS VOID AS $$
     DECLARE r record;
             keytable varchar;
             keydbrid varchar;
     BEGIN
       keytable:='belkopf';
       keydbrid:=src_dataRow.dbrid;
       DELETE FROM recnokeyword WHERE r_tablename=keytable AND r_dbrid=keydbrid AND r_descr='keywordsearch' AND r_kategorie='internal system usage';
       --
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.be_bnr,  'be_bnr', keydbrid);
       
       RETURN;
     END $$ LANGUAGE plpgsql;  
 --
 
 -- Eingangsrechnung (Kopf), #7157
 CREATE OR REPLACE FUNCTION TSystem.kws_create_keywords(IN src_dataRow eingrechdokument) RETURNS VOID AS $$
     DECLARE r record;
             keytable varchar;
             keydbrid varchar;
     BEGIN
       keytable:='eingrechdokument';
       keydbrid:=src_dataRow.dbrid;
       -- Nur die Felder der Kopf-Tabelle löschen
       DELETE FROM recnokeyword WHERE r_tablename=keytable AND r_dbrid=keydbrid AND r_unit LIKE 'beld_%' AND  r_descr='keywordsearch' AND r_kategorie='internal system usage';
       --
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.beld_dokunr,         'beld_dokunr',          keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.beld_refbeleg,       'beld_refbeleg',        keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.beld_vertragsnummer, 'beld_vertragsnummer',  keydbrid);
       
       RETURN;
     END $$ LANGUAGE plpgsql; 
 --
 
 -- Eingangsrechnung (Pos), #7157
 CREATE OR REPLACE FUNCTION TSystem.kws_create_keywords(IN src_dataRow belegpos) RETURNS VOID AS $$
     DECLARE r record;
             keytable varchar;
             keydbrid varchar;
     BEGIN
       keytable:='eingrechdokument';
       -- Positionen über Kopf-Dbrid ablegen
       SELECT dbrid INTO keydbrid FROM eingrechdokument WHERE beld_id = src_dataRow.belp_dokument_id;
       -- Nur die Felder der Pos-Tabelle löschen
       DELETE FROM recnokeyword WHERE r_tablename=keytable AND r_dbrid=keydbrid AND r_unit LIKE 'belp_%' AND r_descr='keywordsearch' AND r_kategorie='internal system usage';
       --
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.belp_referenz,      'belp_referenz',       keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.belp_akbez,         'belp_akbez',          keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.belp_referenzaknr,  'belp_referenzaknr',   keydbrid);
       PERFORM TSystem.kws_CreateKeyword(keytable, src_dataRow.belp_projektnummer, 'belp_projektnummer',  keydbrid);
       
       RETURN;
     END $$ LANGUAGE plpgsql;
 --
---

 
--Druckeinstellungen für Datensatz
    -- Druckeinstellungen für Datensatz kopieren
    CREATE OR REPLACE FUNCTION TReporting.recnokeyword__print_setting__copy(
        IN _src_table varchar, 
        IN _src_id integer, 
        IN _dest_table varchar, 
        IN _dest_id integer, 
        IN _print_setting varchar DEFAULT null -- 'psPriceMainPos' ()
        ) 
        RETURNS void 
        AS $$
        DECLARE
          src_dbrid varchar;
          dest_dbrid varchar;
          rec record;
        BEGIN
          -- Printsetting ist nur **ein** Datensatz. Dieser entält semmikolonseparaiert die unterschiedlichen Settings!
          --Angebot>Auftrag
          IF _src_table = 'auftg' AND _dest_table = 'auftg' THEN
             src_dbrid  := (SELECT dbrid FROM auftg WHERE ag_id = _src_id);
             dest_dbrid := (SELECT dbrid FROM auftg WHERE ag_id = _dest_id);
          END IF;   
          
          --Auftrag>Lieferschein
          IF _src_table = 'auftg' AND _dest_table = 'belegpos' THEN
             src_dbrid  := (SELECT dbrid FROM auftg WHERE ag_id = _src_id);
             dest_dbrid := (SELECT dbrid FROM belegpos WHERE belp_id = _dest_id);
          END IF;   
        
          --Lieferschein>Rechnung
          IF _src_table = 'belegpos' AND _dest_table = 'belzeil_auftg_lif' THEN
             src_dbrid  := (SELECT dbrid FROM belegpos WHERE belp_id = _src_id);
             dest_dbrid := (SELECT dbrid FROM belzeil_auftg_lif WHERE bz_id = _dest_id);
          END IF;   
          
          --Auftrag>Rechnung
          IF _src_table = 'auftg' AND _dest_table = 'belzeil_auftg_lif' THEN
             src_dbrid  := (SELECT dbrid FROM auftg WHERE ag_id = _src_id);
             dest_dbrid := (SELECT dbrid FROM belzeil_auftg_lif WHERE bz_id = _dest_id);
          END IF;   
        
          --Gutschrift auf Rechnung
          IF _src_table = 'belzeil_auftg_lif' AND _dest_table = 'belzeil_auftg_lif' THEN
             src_dbrid  := (SELECT dbrid FROM belzeil_auftg_lif WHERE bz_id = _src_id);
             dest_dbrid := (SELECT dbrid FROM belzeil_auftg_lif WHERE bz_id = _dest_id);
          END IF;   

          FOR rec IN SELECT * FROM recnokeyword 
                     WHERE r_reg_pname = 'System.Printing' 
                       AND r_tablename = _src_table 
                       AND r_dbrid = src_dbrid 
                       AND (_print_setting IS null OR r_value ILIKE '%' || _print_setting || '%') 
          LOOP
             --PERFORM TReporting.recnokeyword__print_setting__set(_dest_table, coalesce(_print_setting, rec.r_value), dest_dbrid);
             PERFORM TReporting.recnokeyword__print_setting__set(
                       _dest_table, 
                       coalesce(_print_setting, 
                                TSystem.ENUM_DelValues__list__exclude__values(
                                          rec.r_value, 
                                          tsystem.settings__get('PrintSettings_ignore_when_copying') --außer Settings die als 'ignoriert' definiert sind #19691
                                        )
                               ), 
                       dest_dbrid
                     ); 
          END LOOP;

        END $$ LANGUAGE plpgsql; 
    
    
    -- Druckeinstellungen für Datensatz holen.
    CREATE OR REPLACE FUNCTION TReporting.recnokeyword__print_setting__get(
        INOUT ps_dbrid varchar, 
        OUT   ps_settings varchar
        ) 
        RETURNS record 
        AS $$
        BEGIN
           SELECT r_dbrid, r_value 
             INTO ps_dbrid, ps_settings
             FROM recnokeyword
            WHERE r_reg_pname = 'System.Printing'
              AND r_dbrid = ps_dbrid;

           RETURN;
        END $$ LANGUAGE plpgsql STABLE;
    --
   
    -- Druckeinstellungen für Datensatz setzen
    -- (Parameter tablename erhalten für Abwärtskompatibilität)
    CREATE OR REPLACE FUNCTION TReporting.recnokeyword__print_setting__set(
        IN _tablename varchar, 
        IN _rvalue varchar, 
        IN _rdbrid varchar, 
        IN _remove boolean DEFAULT false
        ) 
        RETURNS void 
        AS $$
        DECLARE _settings_list varchar;
        BEGIN
          _settings_list := ps_settings FROM TReporting.recnokeyword__print_setting__get(_rdbrid);
          _settings_list := coalesce(_settings_list, '');
  
          IF _remove THEN -- PrintSetting entfernen
            _settings_list := TSystem.ENUM_DelValue(_settings_list, _rvalue);
          ELSE -- PrintSetting hinzufügen
            _settings_list := TSystem.ENUM_SetValue(_settings_list, _rvalue);
          END IF;
          
          IF coalesce(_settings_list, '') = '' THEN
             PERFORM TRecnoParam.Delete('System.Printing', _rdbrid);
          ELSE
             PERFORM TRecnoParam.SetValue('System.Printing', _rdbrid, _settings_list, TRUE, NULL, NULL, _tablename);
          END IF;
  
          RETURN;
        END $$ LANGUAGE plpgsql VOLATILE;
---